<?php
/*	Generate a fresh iCal calendar when invoked (e.g. as a URL from iCal). This ensures that the latest changes are always presented, instead of periodically (and wastefully) generating the file. */

/*	Setup. */
require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";
require_once ".config.php";
require_once ".regconnect.php";
require_once "mysql_utilities.php";
require_once "icalutils.php";

define('QUADODO_IN_SYSTEM', true);
mysql_login('Read-only');

/*	Get event information. Adjust this as required to include the desired
	categories of events. */

	$online_esprit = (ONLINE_ESPRIT == true ? 'AND v.venue_type = "Online"' : 'AND v.venue_type != "Online"');

$sql_info = "SELECT p.bus_name bus_name, p.bus_desc bus_desc,
	r.firstnamepref firstname, r.lastnamepref lastname,
	p.resourcedate resourcedate,
	p.resourceduration resourceduration,
	r.esprit_year esprit_year, p.resourceroom resourceroom, p.id pid,
	p.resourceformat resourceformat
FROM regpresenter p
INNER JOIN reg r 
	ON r.confirmation_no=p.confirmation_no
INNER JOIN regvenues v
	ON v.venue_long=p.resourceroom
WHERE r.confirmation_no=p.confirmation_no
	AND r.esprit_year=$esprit_year
	AND p.resourceformat != 'Blocking'
	AND r.is_presenter='Yes'
	AND p.resourcestatus like '%Scheduled%'
	$online_esprit
ORDER BY resourcedate";



// SELECT p.bus_name bus_name, p.bus_desc bus_desc,
// 	r.firstnamepref firstname, r.lastnamepref lastname,
// 	UNIX_TIMESTAMP(p.resourcedate) resourcedate,
// 	UNIX_TIMESTAMP(TIMESTAMPADD(MINUTE, p.resourceduration, p.resourcedate)) resourceend,
// 	r.esprit_year esprit_year, p.resourceroom resourceroom, p.id pid,
// 	p.resourceformat resourceformat
// FROM regpresenter p,reg r
// 	INNER JOIN reg r ON r.confirmation_no=p.confirmation_no
// 	INNER JOIN regvenues v ON v.venue_long=p.resourceroom
// WHERE r.confirmation_no=p.confirmation_no
// 	AND r.esprit_year=$esprit_year
// 	AND resourceformat != 'Blocking'
// 	AND r.is_presenter='Yes'
// 	AND v.venue_type = \"Online\"
// 	AND p.resourcestatus like '%Scheduled%'";
// print $sql_info;
$result = mysqli_query($GLOBALS['dbConnect'], $sql_info) or die('Database error on venue query: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql_info);

$r = <<<PREAMBLE
BEGIN:VCALENDAR
METHOD:PUBLISH
VERSION:2.0
X-APPLE-CALENDAR-COLOR:#04D404
X-WR-CALNAME:Esprit Schedule
PRODID:-//Esprit Gala//iCalendar Generator//EN
X-WR-TIMEZONE:America/Vancouver
CALSCALE:GREGORIAN
BEGIN:VTIMEZONE
TZID:America/Vancouver
BEGIN:DAYLIGHT
TZOFFSETFROM:-0800
RRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU
DTSTART:20070311T020000
TZNAME:PDT
TZOFFSETTO:-0700
END:DAYLIGHT
BEGIN:STANDARD
TZOFFSETFROM:-0700
RRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU
DTSTART:20071104T020000
TZNAME:PST
TZOFFSETTO:-0800
END:STANDARD
END:VTIMEZONE
PREAMBLE;
$inc = 0;
while ($row = mysqli_fetch_assoc($result)) {
	$rdateraw = new DateTime($row['resourcedate']);
	$rdate = $rdateraw->format('Ymd\THis');
	$edateraw = new DateTime($row['resourcedate']);
	date_add($edateraw,date_interval_create_from_date_string($row['resourceduration']." minutes"));
	$edate = $edateraw->format('Ymd\THis');
	$now = $today->format('Ymd\THis');
	$desc = $row['bus_desc'];
	$inc++;
	$desc = substr($row['bus_desc'], 0, 200);
	$splitline = rtrim(implode("\n ", str_split(strip_tags($desc), 60)));
	$r .= "
BEGIN:VEVENT
SUMMARY:{$row['bus_name']}
LOCATION:{$row['resourceroom']}
STATUS:CONFIRMED
TRANSP:TRANSPARENT
UID:esprit{$row['esprit_year']}:presenter:{$row['pid']}:$inc
DTSTART:$rdate
DTEND:$edate
DTSTAMP:$rdate
DESCRIPTION:$splitline
END:VEVENT";
}
mysql_logout();	//	Disconnect from database

$r .= "
END:VCALENDAR
";
print str_replace(["\r\n", "\r", "\n"], "\r\n", strip_tags($r));

?>
