<?php
/*	Esprit Dynamic Calendar
	Stephanie Mitchell, 19 March, 2013
	This displays a calendar of events for the current year's Esprit in a
	grid form. It uses jQuery and the Vertical Tabs plug-in for
	display. Data is gathered day by day directly from the Esprit MySQL
	database, thus it is always current.
	
	Events and presentations appear in the calendar if their status is
	"Scheduled". If they are "Approved" (but not yet scheduled) they have a
	"tentative" notation. If they have been cancelled they will have a line
	through them and will be greyed out.
	
	Updated 20 January, 2013 to use iframes for MS Internet Explorer, which
	doesn't handle AJAX calls properly.
	
	Updated 30 April, 2014 to support kiosk mode when called from video schedule (secure.cornbury.org/esprit/video).
	
	Updated August 2016 to use Highslide windowing system instead of Fancybox, which appears to be no longer supported.
	
	Updated February 2018 for cleaner calendar and separate button for printable format.
*/

$testing = (array_key_exists('mode', $_REQUEST) ? $_REQUEST['mode'] == 'test': false);
$standalone = true; //	($_REQUEST['view'] == 'standalone');

$live = !$testing;
define('QUADODO_IN_SYSTEM', true);
require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";
require_once ".config.php";
global $cal_testing;
$cal_testing = isset($_REQUEST['mode']) ? ($_REQUEST['mode'] == 'test') : false;
$range_override = isset($_REQUEST['override']) ? ($_REQUEST['override'] == $GLOBALS['committee_override']) : false;
if ($range_override) {	//	set override cookie if override key is given
	setcookie('esprit_calendar_override', true, 0);
} else {				//	delete override cookie otherwise
	setcookie('esprit_calendar_override', false, time()-86400);
}
$orientation = isset($_REQUEST['o']) ? ($_REQUEST['o'] == 'h') : false;
$cal_testing |= TESTING;	//	Override if testing is set in config.php

$standalone = isset($_REQUEST['view']) ? ($_REQUEST['view'] == 'standalone') : false;
require_once 'functions.php';
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<meta http-equiv="Pragma" content="no-cache" />
<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
<meta http-equiv="Expires" content="-1" />
<!-- meta http-equiv="X-Frame-Options" content="allow-same-origin" / -->
<?php
$is_msie = (strpos($_SERVER['HTTP_USER_AGENT'], 'MSIE') > 0);
if (isset($_REQUEST['msie'])) {
	$is_msie = $_REQUEST['msie'];
}

$cal_live = !$cal_testing;
$test_msg = $cal_testing ? 'TEST' : '';
$printable = isset($_REQUEST['format']) ? ($_REQUEST['format'] == 'p') : false;
?>
<title>
<?php
if (ONLINE_ESPRIT == true) {
	print "Esprit $esprit_year VIRTUAL (Online) VERSION Calendar $test_msg";
} else {
	print "Esprit $esprit_year Event Calendar $test_msg";
}
?>
</title>
<!-- Include JQuery Core-->
<script type="text/javascript" src="/mgrlib/js/jquery.js"></script>
<script type="text/javascript" src="/mgrlib/js/jquery-ui.js"></script>
<script type="text/javascript" src="/mgrlib/js/jquerymobile.js"></script>

<!-- Offer mobile-friendly alternative if on a mobile device (screen narrower than 768px)
-->
<script>
window.onload = function () {
// Is screen width less than or equal to 768px (commonly used for mobile)?
	if (window.innerWidth <= 768) {
	// Ask the user if they want to switch to the mobile version
		if (confirm("You're on a mobile device. Switch to mobile-friendly schedule?"))
			window.location.href = "daybytime.php";
	}
};
   </script>

<!-- Highslide code -->
<script type="text/javascript" src="/js/highslide/highslide-full.js"></script>
<!-- 
<script type="text/javascript" src="/regdir/lib/js/highslide/mobile.js"></script>
 -->
<script type="text/javascript" src="/js/highslide/highslide-config.js"></script>
<link rel="stylesheet" type="text/css" href="/js/highslide/highslide.css">
<!-- 
<link rel="stylesheet" type="text/css" href="/css/biostyles.css">
 -->

<link href="/mgrlib/css/detail-theme/jquery-ui-1.10.0.custom.css" rel="stylesheet" type="text/css" media="all" />
<link href="/css/styles.css" rel="stylesheet" type="text/css" />
<!-- place last so it can override jQuery styles-->

<!-- Accordion and highslide initialisation -->
<?php
if (!$printable) {
	print "<script>
	$(document).ready(function() {
	  $('.calendarpage').accordion({active: 0,
	  	header: 'h4',
	  	heightStyle: 'content',
	  	active: false,	//	start with no panels open
	  	collapsible: true});
	});
	/*	Fix highslide graphic directory */
	/* hs.graphicsDir = '/mgrlib' + hs.graphicsDir; */
</script>";
}
print "<script>
	$(document).ready(function() {
		$('.setup, .teardown').hide();
	});
</script>";
?>
<!-- Fix highslide graphic directory -->
<script type="text/javascript">
	hs.graphicsDir = '/mgrlib/js/highslide/graphics/';
</script>
</head>

<body class="calendarpage">
<?php
print "<h2><img src=\"../mgrimg/logo.gif\" width=\"280\" /><br />";
if (ONLINE_ESPRIT == true) {
	print "Esprit $esprit_year VIRTUAL (Online) VERSION Calendar $test_msg";
} else {
	print "Esprit $esprit_year Event Calendar $test_msg";
}
print '</h2><div class="noprint">';
print switchboard();
print legend();
print '</div>';
if ($cal_testing) {
	print '<span class="errormsg">THE SCHEDULE IS IN TEST MODE.<br />
	displaying test data... </span>';
}
/*
	Get the dates and venue counts for each day of Esprit
*/

$date_array = calendar_info($esprit_year, $_COOKIE['esprit_calendar_override']);	
/*	Begin day-by-day accordion section */

/* 	Process dates  */

print '<div class="calendarpage">';	//	Main calendar container
if (!$printable) {
	print "<p style=\"font-weight: normal\">Click day headings for details.</p>";
} else {
	print '<p class="noprint errormsg">Print in landscape and scale to 85% to fit 8.5x11 paper.<br />This text, the button bar and the legend will not print.</p>';
}
foreach ($date_array as $x => $d) {
// 	print_r($d);
	$pdateraw =(new DateTimeImmutable())->createFromFormat('Y-m-d', $d['d_num']);
	$pdate = $pdateraw->format('l j F Y');
	if ($printable) {
		print '<div class="nobreak">';
	}
	print "<h4>$pdate</h4>";
	if ($orientation == 'h') {	//	Change orientation only if explicitly requested
		print format_day_grid($d['d_num'], 0.8, 28, 130, 65);
	} else {
		if ($printable) {	//	Tweak format for printable output
			print format_day_grid_v($d['d_num'], 30, 120, 70, 'pt', $printable, $_COOKIE['esprit_calendar_override']);
		} else {
			print format_day_grid_v($d['d_num'], 30, 115, 65, 'pt', $printable, $_COOKIE['esprit_calendar_override']);
		}
	}
	if ($printable) {
		print '</div>';		//	end of nobreak pagination control div
	}
}
print '</div><!-- end of id="calendarpage" -->';
?>

<div id="endDiv">
</div>
   </body>
</html>
