<?php

/*
	Sets up and displays the event data in a print-friendly format, sorted by day, time
	and venue.
*/

require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";
require_once ".config.php";
require_once ".regconnect.php";
require_once "mysql_utilities.php";
require_once "functions.php";
mysql_login('Read-only');

$sql_info = "SELECT r.firstnamepref fname, r.lastnamepref lname,
	s.bus_name bus_name, DATE_FORMAT(s.resourcedate,'%l:%i%p') resourcetime,
	DATE_FORMAT(s.resourcedate,'%W %M %e') resourceday,
	s.resourcedate resourcedate, s.bus_desc bus_desc,
	DATE_FORMAT(s.resourcedate,'%l:%i%p') resourcestarttime,
	DATE_FORMAT(TIMESTAMPADD(MINUTE, s.resourceduration, s.resourcedate), '%l:%i%p') resourceend,
	s.resourceduration resourceduration, s.resourceroom resourceroom,
	s.id sessionid, s.confirmation_no confirmation_no,
	s.resourcestatus resourcestatus, s.resourceformat resourceformat,
	v.venue_addr address
FROM regpresenter s
INNER JOIN reg r ON r.confirmation_no=s.confirmation_no
INNER JOIN regvenues v ON v.venue_long=s.resourceroom
	AND r.is_presenter='1'
	AND s.resourcestatus IN ('Approved', 'Scheduled', 'Cancelled')
ORDER BY s.resourcedate, resourcestarttime, s.resourceroom";

//	print 'Final SQL query: '.$sql;
	
$result_info = mysqli_query($GLOBALS['dbConnect'], $sql_info) or die('Database error on event info query: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql_info);
while ($row = mysqli_fetch_assoc($result_info)) {	//	Split into days and start times
	//	Create array first time for PHP 7.1
	if (!is_array($data[$row['resourceday']][$row['resourcetime']])) {
		$data[$row['resourceday']][$row['resourcetime']] = array();
	}
	$data[$row['resourceday']][$row['resourcetime']][] = $row;
}
mysql_logout();	//	Disconnect from database

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<meta http-equiv="Pragma" content="no-cache" />
<meta http-equiv="Expires" content="-1" />
<meta name="viewport" content="width=device-width, initial-scale=1.0"/>
<?php
	define('QUADODO_IN_SYSTEM', true);
?>
<title><?php print "Esprit $esprit_year Event Calendar $test_msg";?></title>
<link href="/css/reportstyles.css" rel="stylesheet" type="text/css" />
</head>
<body>
<?php
print "<h2><img style=\"display: inherit\" src=\"/regdir/images/logo.gif\" width=\"280\" /><br />Esprit $esprit_year Schedule by Time $test_msg</h2>";
if (TESTING) {
	print '<span class="errormsg">THE SCHEDULE IS IN TEST MODE.<br />
	displaying test data... </span>';
}
foreach ($data as $this_day => $day_data) {
	print '<div>';
	print "
	<h3>$this_day</h3>";
	foreach ($day_data as $this_time => $time_data) {
		print '<div>';
		print "<h4>$this_time</h4>";
		foreach ($time_data as $this_event => $event_data) {
			print '<div>';
			$pr = $event_data['fname'] == 'Esprit Master' ? '' : "{$event_data['fname']} {$event_data['lname']}";
			print <<<ELEMENT
			<h5>{$event_data['bus_name']}</h5>
			<p class="bold">{$event_data['resourceroom']}<span style="font-size: 80%; font-weight: normal"> <em>({$event_data['address']})</em></span><br />
			$pr</p>
			{$event_data['bus_desc']}
ELEMENT;
		print '</div>';
		}
		print '</div>';
	}
	print '</div>';
}
/*

Data format

    [fname] => Esprit Master
    [lname] => 
    [bus_name] => Early Registration
    [resourcetime] => 6:00PM
    [resourceday] => Sunday May 13
    [resourcedate] => 2018-05-13 18:00:00
    [resourcestarttime] => 6:00PM
    [resourceend] => 6:30PM
    [resourceduration] => 30
    [resourceroom] => Juan de Fuca
    [sessionid] => 1151
    [confirmation_no] => 18060000
    [resourcestatus] => Scheduled
    [resourceformat] => Event
    [address] => North (waterside) ballroom, upstairs in the main block of the hotel. Make a U-turn at the top of the stairs.

*/
exit;
?>
