<?php
/*
	Sets up and displays the "Add New" tab for the Attendees
	susbystem. Only appears in the attendees screen, and only for Admin users.
	
	Stephanie Mitchell, 4 April, 2023
*/
/*
	See if logged in via Quadodo
*/

global $tpl;
define('QUADODO_IN_SYSTEM', true);
$dirname = dirname(__FILE__);
$basename = dirname($dirname);

require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";
require_once "mysql_utilities.php";
require_once "header.php";
require_once ".config.php";
require_once "setup.php";
require_once "fieldlist.php";
require_once "template_options.php";
require_once "qrmake_attendee_fn.php";
require_once "generate_confirmation.php";
$tpl['authgroup'] = $qls->group_id_to_name($qls->user_info['group_id']);
$tpl['username'] = $qls->user_info['username'];
if ($tpl['username'] == '') {
	header('Location: ../qls/login.php');
	exit;
}

$primarykeyfieldvalue = $_REQUEST['pkfv'];
$primarykeyfieldname = $_REQUEST['pkfn'];
$group = $_REQUEST['group'];

/*	Force a distinctive first name to identify the new record and tweak certain
	fields to current year, pre-registered and such. Also set remaining meals to allotted meals. */
$newdata = $fields;
$newdata['firstnamepref']['copyValue'] = ' (NEW)';
$newdata['esprit_year']['copyValue'] = $GLOBALS['esprit_year'];
$newdata['confirmation_no']['copyValue'] = generate_confirmation();	// New number required
$newdata['badge_code']['copyValue'] = generate_badge_code();	// New code required
$newdata['reg_status']['copyValue'] = '';
// unset($newdata['timestamp']);	//	MySQL inserts this automatically
// unset($newdata['updatetime']);	//	MySQL inserts this automatically
// unset($newdata['checkindate']);	//	Null because new record can't have checked in yet
// print_r($newdata);
// die();
mysql_login('Normal');

// insert the new record and get the new auto_increment id
$sql = "INSERT INTO regall (`{$primarykeyfieldname}`) VALUES (NULL)";
$result = mysqli_query($GLOBALS['dbConnect'], $sql) or SM_Die('Database error on insert while creating new record: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql, 'Unable to create new record - sorry!');

$newid = mysqli_insert_id($GLOBALS['dbConnect']);
$newdata[$primarykeyfieldname] = $newid;

/*
	Generate the query to update the new record with the default copyValue values from
	fieldlist.php.
*/

$sql = "UPDATE regall SET ";
foreach ($newdata as $key => $value) {
	if ($key != $primarykeyfieldname) {
		if (isset($newdata[$key]['copyValue'])) {
			$sql .= '`'.$key.'` = "'.str_replace('"','\"',$newdata[$key]['copyValue']).'", ';
		}
	}
} 

qrmake_attendee($newdata['confirmation_no'], $newdata['badge_code']);

$sql = substr($sql, 0, strlen($sql)-2); // lop off extra trailing comma
$sql .= " WHERE {$primarykeyfieldname}={$newid}";
$sql_escaped = $sql; // mysqli_real_escape_string($GLOBALS['dbConnect'], $sql);
$result = mysqli_query($GLOBALS['dbConnect'], $sql_escaped) or SM_Die('Database error on update while copying attendee to current year: ' . mysqli_error($GLOBALS['dbConnect']) . ". Query=$sql_escaped", 'Unable to update information while copying attendee to current year - sorry!');

Make_Log_Entry($GLOBALS['dbConnect'], "NEW ATTENDEE ADDED VIA COPY TO CURRENT: $sql_escaped<br />TRANSACTIONS COPIED: $sqltrans_escaped");

$e = new Smarty_Esprit;
$e->addPluginsDir("{$_SERVER['DOCUMENT_ROOT']}/plugins/");
$e->registerPlugin("modifier","ss", "stripslashes");
$e->assign('mydata',$newdata);
// print_r($tpl);
$e->addTemplateDir("{$_SERVER['DOCUMENT_ROOT']}/templates/");
$e->addTemplateDir("{$_SERVER['DOCUMENT_ROOT']}/$dirname/templates/");
$e->display('basic_detail.tpl');

?>
