<?php
/*
	Esprit Online Registration System
	Stephanie Mitchell, 23 November, 2017
	
	This  file contains the fieldlist details for SM_SQLEdit.
	It lists all the fields in the relevant database along with parameters
	that control their display and other characteristics.
	
	Parameters are described in detail in /help/fieldlistdoc.php.
	
*/
/*	Protect from non-logged in users */
defined('QUADODO_IN_SYSTEM') or header('HTTP/1.1 403 Forbidden')&die('Restricted access');

/* MySQL table names */
global $opts, $all_years;

/* MySQL table names */

if ($all_years) {	//	Dummy logic in case we add years later
	$db['tb'] = 'regemailcontrol r';
	$db['tbnoalias'] = 'regemailcontrol';
} else {
	$db['tb'] = 'regemailcontrol r';
	$db['tbnoalias'] = 'regemailcontrol';
}

$opts['join_clause'] = '';
$letter_groups = get_letter_groups();

/* Field definitions start here */

$fields['letter_id'] = [
		'heading' => "Letter ID",
		'table' => 'r',
		'display' => false,
		'fieldgroup' => '*',
		'primarykey' => true,
		'filter' => ""];
$fields['letter_group'] = [
		'heading' => "Group",
		'long_heading' => "Letter Group",
		'table' => 'r',
		'widget' => 'menu',
		'allowedvalues' => $letter_groups,
		'allowedlabels' => $letter_groups,
		'display' => true,
		'width' => '10%',
		'fieldgroup' => '*, Master',
		'arrayedit' => true,
		'filter' => ""];
$fields['letter_sequence'] = [
		'heading' => "Letter Sequence",
		'table' => 'r',
		'display' => false,
		'arrayedit' => false,
		'fieldgroup' => '*',
		'filter' => ""];
$fields['letter_rule'] = [
		'heading' => "Rule table",
		'table' => 'r',
		'display' => false,
		'arrayedit' => false,
		'fieldgroup' => '*',
		'search_more' => true,
		'filter' => ""];
$fields['letter_name'] = [
		'heading' => "Letter Name",
		'table' => 'r',
		'display' => true,
		'arrayedit' => true,
		'width' => '20%',
		'fieldgroup' => 'Master, *',
		'filter' => ""];
$fields['letter_from'] = [
		'heading' => "From addr",
		'long_heading' => "Sender's Email",
		'table' => 'r',
		'display' => true,
		'width' => '25%',
		'arrayedit' => true,
		'fieldgroup' => '*, Master',
		'search_more' => true,
		'filter' => ""];
$fields['letter_to'] = [
		'heading' => "To addr",
		'long_heading' => "Recipient's",
		'table' => 'r',
		'display' => true,
		'width' => '25%',
		'arrayedit' => true,
		'fieldgroup' => 'Master,*',
		'search_more' => true,
		'filter' => ""];
$fields['letter_cc'] = [
		'heading' => "CC addr",
		'long_heading' => "CC Emails",
		'table' => 'r',
		'display' => false,
		'arrayedit' => false,
		'fieldgroup' => '*',
		'search_more' => true,
		'filter' => ""];
$fields['letter_bcc'] = [
		'heading' => "BCC addr",
		'long_heading' => "BCC Emails",
		'display' => false,
		'arrayedit' => false,
		'fieldgroup' => '*',
		'search_more' => true,
		'filter' => ""];
$fields['letter_subject'] = [
		'heading' => "Subject",
		'table' => 'r',
		'display' => true,
		'width' => '20%',
		'arrayedit' => true,
		'fieldgroup' => '*, Master',
		'filter' => ""];
$fields['letter_html_file'] = [
		'heading' => "External HTML Template",
		'table' => 'r',
		'display' => false,
		'arrayedit' => false,
		'fieldgroup' => '*',
		'filter' => ""];
$fields['letter_comments'] = [
		'heading' => "Comments",
		'long_heading' => "Comments about Record",
		'display' => false,
		'fieldgroup' => '*',
		'filter' => ""];
$fields['letter_html'] = [
		'heading' => "Template inline",
		'long_heading' => "Inline HTML Template",
		'table' => 'r',
		'fieldgroup' => '*',
		'display' => false,
		'arrayedit' => false,
		'widget' => 'textarea',
		'search_more' => true,
		'filter' => ""];
$fields['letter_attachments'] = [
		'heading' => "Attachments Control",
		'table' => 'r',
		'fieldgroup' => '*',
		'search_more' => true,
		'display' => false,
		'arrayedit' => true,
		'filter' => ""];
$fields['letter_online_esprit'] = [
		'heading' => "Esprit Online",
		'long_heading' => "Use ONLY for Online Esprit",
		'table' => 'r',
		'display' => true,
		'width' => '20%',
		'widget' => 'menu',
		'allowedvalues' => ["Yes", "No"],
		'allowedlabels' => ["Yes", "No"],
		'arrayedit' => true,
		'fieldgroup' => 'Master, *',
		'filter' => ""];
$fields['letter_timestamp'] = [
		'heading' => "Created",
		'table' => 'r',
		'display' => true,
		'search_more' => true,
		'width' => '10%',
		'fieldgroup' => 'Master, Detail',	//	No copy to new
		'filter' => ""];
$fields['letter_updated'] = [
		'heading' => "Updated",
		'table' => 'r',
		'display' => true,
		'css' => 'font-size:80%',
		'date_format' => '%d%b%Y<br />%T',
		'search_more' => true,
		'width' => '10%',
		'fieldgroup' => 'Master, Detail',	//	No copy to new
		'filter' => ""];

/* End of Field definitions. */

/* Field group definitions */

if (!$all_years) {
	$tpl['fieldgroups'] = [
	/*	'Blank' => ['label' => '>',
			'url' => 'blank.php'], */
		'Master' => ['label'=>'Master',
			'url' =>''],
		'Detail' => ['label' => 'Details',
			'url' => 'taburl.php?template=emailcontrol_detail.tpl',
			'width' => '1400',
			'authgroup' => ['Admin']],
		'AddNew' => ['label' => 'Copy',
			'url' => 'add.php',
			'authgroup' => ['Admin'],
			'scroll' => 'No'	//	Prevent scrolling to this screen
		],
		'Logs' => ['label' => 'Log Entries',
			'url' => "../log-list.php?tbname={$db['tbnoalias']}",
			'width' => 1500,
			'height' => 800,
			'authgroup' => ['Admin']],
		'DeleteThis' => ['label' => 'Delete',
			'url' => 'delete.php',
			'authgroup' => ['Admin'],
			'scroll' => 'No'	//	Prevent scrolling to this screen
		],
	];
} else {
	$tpl['fieldgroups'] = [
	/*	'Blank' => ['label' => '>',
			'url' => 'blank.php'], */
		'Master' => ['label'=>'Master',
			'url' =>''],
		'Detail' => ['label' => 'Details',
			'url' => 'taburl.php?template=emailcontrol_detail.tpl&access=read_only&all_years=true',
			'width' => '1400',
			'authgroup' => ['Admin']],
		'AddNew' => ['label' => 'Copy',
			'url' => 'add.php',
			'authgroup' => ['Admin'],
			'scroll' => 'No'	//	Prevent scrolling to this screen
		],
		'Logs' => ['label' => 'Log Entries',
			'url' => "../log-list.php?tbname={$db['tbnoalias']}",
			'width' => 1500,
			'height' => 800,
			'authgroup' => ['Admin']],
// 		'DeleteThis' => ['label' => 'Delete',
// 			'url' => 'delete.php',
// 			'authgroup' => ['Admin'],
// 			'scroll' => 'No'	//	Prevent scrolling to this screen
// 		],
	];
}

function get_letter_groups() {
	/*	Get list of letter groups from the regemailcontrol table.
		
		Check for online Esprit instead of in-person, restrict offerings
	*/
	include_once "online_switch.php";

	require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";
	require_once "mysql_utilities.php";
	global $tpl;
	$temp_access = $tpl['access'];
	mysql_login('Normal');
	$tpl['access'] = $temp_access;
	$sql = 'SELECT DISTINCT letter_group 
	FROM regemailcontrol WHERE letter_online_esprit=' . (ONLINE_ESPRIT ? 'true' : 'false');
// 	print $sql;
// 	die();
	$sql_result = mysqli_query($GLOBALS['dbConnect'], $sql) or SM_Die('Database error getting letter group table: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql, 'Unable to retrieve letter groups - sorry!');
	$r = [];
	while ($row = mysqli_fetch_assoc($sql_result)) {
		$r[] = $row['letter_group'];
	}
	return $r;
}


?>