<link href="../lib/css/helpstyles.css" rel="stylesheet" type="text/css" media="all">
<link href="../lib/css/helpstyles.css" rel="stylesheet" type="text/css" media="all">
<body><h3>The Package Manager</h3>

<p>The Package Manager contains all the combinations of days and meals available to participants, as well as the rates charged for each. It is organised into five <strong><em>tiers</em></strong> that correspond to the tiered pricing structure that increases prices from month to month.</p>

<p>Within each tier are two <strong><em>package types</em></strong>: <strong>Full Rate</strong> and <strong>Single Day</strong>. Full Rates are complete packages including multiple days and often (but not necessarily) meals. Single Day packages contain only a single day, again sometimes but not always including the meals for that day (if any).</p>

<p>Within each package type are a number of <strong><em>form types</em></strong>, which correspond to the different types of participants: Single, SO, Additional Family, Presenter, Vendor, Assistant, Guest, Observer, Committee_Full and Committee_Partial.</p>

<p>Each form type in each package type in each tier has its own <strong><em>row</em></strong> in the packages table. Rows are completely independent of each other; nothing is computed from other rows. This means that to adjust things &quot;across the board&quot; you literally must adjust them <em>across the board</em> - that is, you must edit each row involved.</p>

<p>Rows contain the following fields:</p>

<ul>
	<li><strong>Tier:</strong> 1 through 5 to correspond to the tiered pricing structure. Other values may cause problems or be ignored.</li>
	<li><strong>Package Type:</strong> Full Rate or Single Day. Other values will be ignored.</li>
	<li><strong>Form Type:</strong> Single, SO, Additiona_Family, Resource_Presenter, Resource_Vendor, Assistant, Guest, Observer, Committee_Full and Committee_Partial. These correspond to the various types of participant and the form types they use to register (hence the name). Other values will be ignored until an actual form is reated for them. Note the underscores in the values; rhey&#39;re important.</li>
	<li><strong>Code</strong>: this is a 7-character code that abbreviates the package type and form type and adds two characters fo designate Special Rates. The format is <em>pp-t-rr</em>, where:
	<ul>
		<li><em>pp</em> is SS (Sunday-Sunday), WS (Wednesday-Sunday) or FS (Friday-Sunday). It can also be 1S (Single day beginning Sunday), 1M (single day Monday), 1T, tW, 1R (Thursday), 1F, 1A (Saturday) or 1U (Single day ending Sunday). The 1x codes work in conjunction with special rate; more on that later.</li>
		<li><em>t</em> is I (Individual, as in Single), S (SO), F (Additional Family, P (Presenter), V (Vendor), A (Asistant), G (Guest) or O (Observer). Note that Committee members don&#39;t have their own code hhere; they&#39;re usually either I or S.</li>
		<li><em>rr</em> is rate type: FR (full rate), CF (Committee Full Discount), CP (Committee Partial Discount) or SR (Special Rate).</li>
	</ul>
	</li>
	<li><strong>Package Name:</strong> a human-readable string that names the package</li>
	<li><strong>Rate:</strong> the dollar amount charged for this package</li>
	<li><strong>DayS1, DayM, DayT, DayW, DayR, DayF, DayA, DayS2:</strong> eight fields containing either 0 or 1 to indicate whether that day (opening Sunday through closing Sunday) is included in the package.</li>
	<li><strong>MealFB, MealFL, MealFD, MealSL, MealSD, MealUB:</strong> six fields containing either 0 or 1 to indicate wheher a given meal is included. MealFB is Friday Breakfast (originally the Veterans&#39; Breakfast), MealFL is Friday Lunch and so on.</li>
	<li><strong>Meal Selectable:</strong> certain form types (such as Presenters) can select a meal as part of their package. A 1 in this field indicates the meal is selectable, a 0 means it isn&#39;t. If this is set to 1, all other Mealxx fields should be 0..</li>
	<li><strong>Notes:</strong> human-readable one-liner that describes the package for the user.</li>
	<li><strong>Computation Notes:</strong> any comments to yourself to explain how the rate was arrived at, etc.</li>
</ul>

<p>&nbsp;</p>

</body>