<?php
/*
	Esprit Online Registration System
	Stephanie Mitchell, 23 November, 2017
	
	This  file contains the fieldlist details for SM_SQLEdit.
	It lists all the fields in the relevant database along with parameters
	that control their display and other characteristics.
	
	Parameters are described in detail in /help/fieldlistdoc.php.
	
*/
/*	Protect from non-logged in users */
defined('QUADODO_IN_SYSTEM') or header('HTTP/1.1 403 Forbidden')&die('Restricted access');

/* MySQL table names */

$db['tb'] = 'regletters r';
$db['tbnoalias'] = 'regletters';
global $opts;
$opts['join_clause'] = '';
$subsystems = get_subsystems();
$groups = get_letter_groups();

/* Field definitions start here */

$fields['letter_id'] = [
		'heading' => "Letter ID",
		'table' => 'r',
		'display' => false,
		'fieldgroup' => '*',
		'primarykey' => true,
		'filter' => ""];
$fields['letter_system'] = [
		'heading' => "Subsystem",
		'table' => 'r',
		'display' => true,
		'widget' => 'menu',
		'allowedvalues' => $subsystems,
		'width' => '10%',
		'arrayedit' => true,
		'fieldgroup' => '*, Master',
		'filter' => ""];
$fields['letter_group'] = [
		'heading' => "Group",
		'table' => 'r',
		'display' => true,
		'widget' => 'menu',
		'allowedvalues' => $groups,
		'width' => '10%',
		'arrayedit' => true,
		'fieldgroup' => '*, Master',
		'filter' => ""];
$fields['letter_authgroup'] = [
		'heading' => "Authorised Groups",
		'table' => 'r',
		'display' => true,
		'arrayedit' => true,
		'fieldgroup' => '*',
		'filter' => ""];
$fields['letter_sequence'] = [
		'heading' => "Letter Sequence",
		'table' => 'r',
		'display' => true,
		'width' => '10%',
		'arrayedit' => true,
		'fieldgroup' => 'Master, *',
		'filter' => ""];
$fields['letter_name'] = [
		'heading' => "Letter Name",
		'table' => 'r',
		'display' => true,
		'width' => '20%',
		'arrayedit' => true,
		'fieldgroup' => 'Master, *',
		'filter' => ""];
$fields['letter_bulkable'] = [
		'heading' => "Bulk-mailable",
		'table' => 'r',
		'display' => true,
		'width' => '20%',
		'widget' => 'menu',
		'allowedvalues' => ["Yes", "No"],
		'allowedlabels' => ["Yes", "No"],
		'arrayedit' => true,
		'fieldgroup' => 'Master, *',
		'filter' => ""];
$fields['letter_base_sql'] = [
		'heading' => "Base SQL",
		'table' => 'r',
		'display' => true,
		'width' => '20%',
		'arrayedit' => true,
		'fieldgroup' => '*, Master',
		'filter' => ""];
$fields['letter_bulk_sql'] = [
		'heading' => "Bulk SQL",
		'table' => 'r',
		'display' => true,
		'width' => '20%',
		'arrayedit' => true,
		'fieldgroup' => '*, Master',
		'filter' => ""];
$fields['letter_online_esprit'] = [
		'heading' => "Esprit Online",
		'table' => 'r',
		'display' => true,
		'width' => '20%',
		'widget' => 'menu',
		'allowedvalues' => ["Yes", "No"],
		'allowedlabels' => ["Yes", "No"],
		'arrayedit' => true,
		'fieldgroup' => 'Master, *',
		'filter' => ""];
$fields['letter_from'] = [
		'heading' => "From",
		'table' => 'r',
		'display' => true,
		'width' => '20%',
		'arrayedit' => true,
		'fieldgroup' => '*, Master',
		'filter' => ""];
$fields['letter_to'] = [
		'heading' => "To",
		'table' => 'r',
		'display' => true,
		'width' => '10%',
		'arrayedit' => true,
		'fieldgroup' => '*, Master',
		'filter' => ""];
$fields['letter_replyto'] = [
		'heading' => "Reply To",
		'table' => 'r',
		'display' => true,
		'width' => '18%',
		'arrayedit' => true,
		'fieldgroup' => '*, Master',
		'filter' => ""];
$fields['letter_cc'] = [
		'heading' => "CC",
		'table' => 'r',
		'display' => true,
		'arrayedit' => true,
		'fieldgroup' => '*',
		'filter' => ""];
$fields['letter_bcc'] = [
		'heading' => "BCC",
		'table' => 'r',
		'display' => true,
		'arrayedit' => true,
		'fieldgroup' => '*',
		'filter' => ""];
$fields['letter_subject'] = [
		'heading' => "Subject",
		'table' => 'r',
		'display' => true,
		'arrayedit' => true,
		'fieldgroup' => '*',
		'filter' => ""];
$fields['letter_template_text'] = [
		'heading' => "Template Text",
		'table' => 'r',
		'fieldgroup' => '*',
		'display' => true,
		'filter' => ""];
$fields['letter_created'] = [
		'heading' => "Created",
		'table' => 'r',
		'display' => true,
		'date_format' => '%d%b%Y<br />%T',
		'css' => 'font-size:80%',
		'search_more' => true,
		'width' => '10%',
		'fieldgroup' => 'Master, Detail',	//	No copy to new
		'filter' => ""];
$fields['letter_updated'] = [
		'heading' => "Updated",
		'table' => 'r',
		'display' => true,
		'date_format' => '%d%b%Y<br />%T',
		'css' => 'font-size:80%',
		'search_more' => true,
		'width' => '10%',
		'fieldgroup' => 'Master, Detail',	//	No copy to new
		'filter' => ""];

/* Field group definitions */

$tpl['fieldgroups'] = [
	'Master' => ['label'=>'Master',
		'url' =>''],
	'Detail' => ['label' => 'Details',
		'url' => 'taburl.php?template=letters_detail.tpl',
		'authgroup' => ['Admin']],
	'AddNew' => ['label' => 'Copy',
		'url' => 'add.php',
		'authgroup' => ['Admin'],
		'scroll' => 'No'	//	Prevent scrolling to this screen
		],
	'Delete' => ['label' => 'Delete',
		'url' => 'delete.php',
		'authgroup' => ['Admin'],
		'scroll' => 'No'	//	Prevent scrolling to this screen
		],
	'Logs' => ['label' => 'Log Entries',
		'url' => "../log-list.php?tbname={$db['tbnoalias']}",
		'width' => 1500,
		'height' => 800,
		'authgroup' => ['Admin']]
];

function get_subsystems() {
	/*	Get list of letter groups from the regemailcontrol table.
		
		Check for online Esprit instead of in-person, restrict offerings
	*/
	include_once "online_switch.php";

	require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";
	require_once "mysql_utilities.php";
	global $tpl;
	$temp_access = $tpl['access'];
	mysql_login('Normal');
	$tpl['access'] = $temp_access;
	$sql = 'SELECT DISTINCT letter_system
	FROM regletters WHERE letter_online_esprit=' . (ONLINE_ESPRIT ? 'true' : 'false');
// 	print $sql;
// 	die();
	$sql_result = mysqli_query($GLOBALS['dbConnect'], $sql) or SM_Die('Database error getting letter group table: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql, 'Unable to retrieve letter groups - sorry!');
	$r = [];
	while ($row = mysqli_fetch_assoc($sql_result)) {
		$r[] = $row['letter_system'];
	}
	return $r;
}

function get_letter_groups() {
	/*	Get list of letter groups from the regemailcontrol table.
		
		Check for online Esprit instead of in-person, restrict offerings
	*/
	include_once "online_switch.php";

	require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";
	require_once "mysql_utilities.php";
	global $tpl;
	$temp_access = $tpl['access'];
	mysql_login('Normal');
	$tpl['access'] = $temp_access;
	$sql = 'SELECT DISTINCT letter_group
	FROM regletters WHERE letter_online_esprit=' . (ONLINE_ESPRIT ? 'true' : 'false');
// 	print $sql;
// 	die();
	$sql_result = mysqli_query($GLOBALS['dbConnect'], $sql) or SM_Die('Database error getting letter group table: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql, 'Unable to retrieve letter groups - sorry!');
	$r = [];
	while ($row = mysqli_fetch_assoc($sql_result)) {
		$r[] = $row['letter_group'];
	}
	return $r;
}
?>