<?php
function qrmake_attendee($conf, $code) {

	/*
		Creates a QR code image for $code and stores it in a file based on
		$conf. The value passed for $code is 14 randomly genrated bytes. The actual QR code generated is a URL in the format
		https://badge.espritgala.org/?id=yy<code>
		where yy is the two digits of the Esprit year to give a 16-digit code.
	*/
	/*
	 * PHP QR Code encoder
	 *
	 * Exemplatory usage
	 *
	 * PHP QR Code is distributed under LGPL 3
	 * Copyright (C) 2010 Dominik Dzienia <deltalab at poczta dot fm>
	 *
	 * This library is free software; you can redistribute it and/or
	 * modify it under the terms of the GNU Lesser General Public
	 * License as published by the Free Software Foundation; either
	 * version 3 of the License, or any later version.
	 *
	 * This library is distributed in the hope that it will be useful,
	 * but WITHOUT ANY WARRANTY; without even the implied warranty of
	 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
	 * Lesser General Public License for more details.
	 *
	 * You should have received a copy of the GNU Lesser General Public
	 * License along with this library; if not, write to the Free Software
	 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
	 */
	
// 	echo "<b>PHP QR Code</b><hr/>";
// 	echo "Code passed=$code<hr/>";

	require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";
	require_once ".config.php";

	$base_url= $GLOBALS['qrcodedir'];
// 	print $base_url;

	//set it to writable location, a place for temp generated PNG files
	$PNG_TEMP_DIR = dirname(__FILE__).DIRECTORY_SEPARATOR.'qrtemp'.DIRECTORY_SEPARATOR;

	//html PNG location prefixes.
	// Local directory for use inside registration
	$PNG_WEB_DIR = $GLOBALS['qrcodedir'];
	
	// Externally readable directory for access without secure password
	$PNG_EXPORT_DIR = $GLOBALS['qrcodedir'];

	require_once "qrlib.php";	

	//ofcourse we need rights to create temp dir
	if (!file_exists($PNG_TEMP_DIR)) {
		mkdir($PNG_TEMP_DIR);
	}

	if (isset($conf)) {
		$filename = $PNG_WEB_DIR.$conf.'.png';
	} else {
		$filename = $PNG_WEB_DIR.'test.png';
	}
// 	echo "\$filename=$filename<br />";

	/* We already have confirmation no., no database action necessary */
	/*	Compute URL - this must end up as https://badge.<servername>/?id=...	*/
	$urlbase = "https://badge.";
	$urlbase .= substr($_SERVER['HTTP_HOST'], strpos($_SERVER['HTTP_HOST'], '.') + 1);
	$dataline = $urlbase . "/?id={$GLOBALS['esprit_yy']}$code";
// 	die($dataline);
// 	echo "\$dataline=$dataline<br />";
	//processing form input
	//remember to sanitize user input in real-life solution !!!
	$errorCorrectionLevel = 'H';
	$matrixPointSize = 4;
	
// die("\$eclevel: $errorCorrectionLevel");
	if (trim($dataline) == '')
		die('data cannot be empty! <a href="?">back</a>');
		
		// user data
		$tempfilename = $PNG_TEMP_DIR.'test'.md5($dataline.'|'.$errorCorrectionLevel.'|'.$matrixPointSize).'.png';
		QRcode::png($dataline, $filename, $errorCorrectionLevel, $matrixPointSize, 2);	
	
	/*	Now create a file based on the date, time and location and place it
		outside the ssecure website. This will make creating fixed external
		links easier.
	*/
	$export_filename = "$PNG_EXPORT_DIR$conf" . ".png";
	$export_filename = str_replace(' ','', $export_filename);	// remove spaces
// 	echo "<br />\$filename=$filename; \$export_filename=$export_filename<br />";
// 	echo `whoami`;
	chmod($export_filename, 0777);
	copy($filename, $export_filename);
	
}
?>
