<?php
/*
	Check committee list. Must be on either Committee Full or Committee Partial
	AND using the appropriate form. This also checks for duplicate registrations.
*/

/* Get value to check */
$validateValue = trim($_REQUEST['fieldValue']);
$validateValueUC = strtoupper(trim($_REQUEST['fieldValue']));
$validateId = $_REQUEST['fieldId'];

/*
	Gather the parameters from whatever form type they were submitted from
*/
foreach(['Single', 'SO', 'Add_Family', 'Resource_Presenter', 'Resource_Vendor', 'Committee_Full', 'Committee_Partial', 'Assistant', 'Volunteer', 'Guest', 'Observer'] as $ft) {
$fname .= trim($_REQUEST[$ft.'__firstnamepref']);
$lname .= trim($_REQUEST[$ft.'__lastnamepref']);
$email .= trim($_REQUEST[$ft.'__email']);
}
$f = $_REQUEST['type'];	//	List type
require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";
require_once 'blacklist.php';
require_once 'mysql_utilities.php';
mysql_login('Read-only');

/*	Check to see if on blacklist */
if (blacklist($validateValueUC, $mysqlLink)) {	/*	Blacklisted? */
	echo json_encode(array($validateId, false,'Registration DECLINED. Please contact registrar@espritconf.com for assistance.'));
	exit;
}

/*
	Check for duplicate.
*/
/*
	First make sure we have everything we need to check. We could be validating before all
	required fields have been entered. This is so that the check can be done regardless of
	what order the fields were entered.
*/
if (($fname == '') or ($lname == '') or ($email == '')) {	// All fields are required
	echo json_encode(array($validateId, true, "Validated with $fname $lname ($email)"));	//	Continue if missing
	exit;
} else {

$sqlcmd = "SELECT email found_email, DATE_FORMAT(TIMESTAMP,'%D %b, %Y') tstamp
FROM reg
WHERE email=\"$validateValue\"
	AND firstnamepref=\"$fname\"
	AND lastnamepref=\"$lname\"";

$result = mysqli_query($GLOBALS['dbConnect'], $sqlcmd) or die(mysqli_error($GLOBALS['dbConnect']) . ": didn't work");
$row = mysqli_fetch_assoc($result);

/*	TEST EXIT */
// $params = var_export($_REQUEST, true);
// echo json_encode(array($validateId, false, "NCL: Testing duplicate Reg for $params, found {$row['found_email']}"));
// exit;

/*	Do we have a matching record? */
if ($row) {	//	Found duplicate registration, fail
	echo json_encode(array($validateId, false, "This looks like a duplicate registration;<br />it was first submitted on {$row['tstamp']}.<br />Please contact registrar@espritconf.com for assistance."));
	exit;
}

/*	Following SELECT handles wildcard "*" in checklist by replacing them with MySQL's "%" wildcard */
$sqlcmd = "SELECT email, category
FROM regcontrol
WHERE \"$validateValueUC\" LIKE (REPLACE(UPPER(TRIM(email)), '*', '%')) 
	AND TRIM(category) LIKE \"%$f%\"";


$result = mysqli_query($GLOBALS['dbConnect'], $sqlcmd) or die(mysqli_error($GLOBALS['dbConnect']) . ": didn't work");

if (@mysqli_num_rows($result) == 0) {	//	if no matching records found,
										//	not on committee list

echo json_encode(array($validateId, false,'This form is restricted. Please select a different form.'));
} else {
	echo json_encode(array($validateId, true, 'Validated'));
}
}
?>