<?php
/*
	Smarty plugin
	-------------------------------------------------------------
	File:		modifier.yesno.php
	Author:		Stephanie Mitchell
	Date:		15 October, 2015
	Type:		modifier
	Name:		yesno
	Purpose:	returns 'Yes' or 'No' depending on logical value of input
	Parameters:	value		the value to be evaluated.
	How it works:	Translates common logical or textual values to 'Yes' or 'No'
					for display purposes.
 */

function smarty_modifier_yesno($value)
{
	$result = (is_null($value) or $value === false or $value == 0 or trim(strtoupper($value)) == 'NO') ? 'No' : 'Yes';
	return $result;
}
?>
