<?php
/*
	Sets up and displays the "Copy to Current" tab for the Presenters susbystem.
	Only appears in the presentersall screen (All Years Presenters).
	
	Stephanie Mitchell, 4 April, 2023
*/
/*
	See if logged in via Quadodo
*/

global $tpl;
define('QUADODO_IN_SYSTEM', true);
$dirname = dirname(__FILE__);
$basename = dirname($dirname);

require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";
require_once "mysql_utilities.php";
require_once "header.php";
require_once ".config.php";
require_once "generate_confirmation.php";
require_once "setup.php";
require_once "fieldlist.php";
require_once "template_options.php";
$tpl['authgroup'] = $qls->group_id_to_name($qls->user_info['group_id']);
$tpl['username'] = $qls->user_info['username'];
if ($tpl['username'] == '') {
	header('Location: ../qls/login.php');
	exit;
}

$primarykeyfieldvalue = $_REQUEST['pkfv'];
$primarykeyfieldname = $_REQUEST['pkfn'];
$group = $_REQUEST['group'];
$all_years = $_REQUEST['all_years'] ?? '';
mysql_login('Normal');
$mydata = get_mysql_fields('AddNew', $fields, $primarykeyfieldname, $primarykeyfieldvalue, 'regall r, regpresenterall s', 'r.confirmation_no=s.confirmation_no', 's');

/*
	Force a distinctive group name to identify the new record
*/
$mydata['bus_name'] .= ' (NEW)';

$rdate = date_create($mydata['resourcedate']);
$adate = date_create($mydata['resourcealsoadmit']);

/*	Determine how many years separate the current year and the year in the
	record being cloned. */
$ydiff = $esprit_year - $mydata['esprit_year'];


$rdate = getSameDayNextYear($rdate, $ydiff, $GLOBALS['esprit_week_shift']);
$mydata['resourcedate'] = date_format($rdate, 'Y-m-d H:i:s');
$sdate = date_create($mydata['slide_startdisplay']);
$sdate = getSameDayNextYear($sdate, $ydiff, $GLOBALS['esprit_week_shift']);
$mydata['slide_startdisplay'] = date_format($sdate, 'Y-m-d H:i:s');
$mydata['resourcealsoadmit'] = $mydata['resourcedate'];	//	Force to same as resourcedate

$mydata['resourcestatus'] = 'Inquiry';
/*	Now we must figure out which confirmation number to attach the cloned record
	to. We first look for matching email address and is_presenter flag in the
	current year. If there isn't one (usually because the vendor hasn't (yet)
	been cloned), tell the user and suggest she clone the vendor record first.
*/
/*	First get the email address required. Have to look it up in the regall table. */

$sql = "SELECT email
FROM regall
WHERE confirmation_no='{$mydata['confirmation_no']}'";
// print __FILE__ . ':' . __LINE__ .": SQL command is $sql....<br />";
$result = mysqli_query($GLOBALS['dbConnect'], $sql) or SM_Die("Internal error - should be able to find email for confirmation _no {$mydata['confirmation_no']} but can't.");

$r = mysqli_fetch_assoc($result);

$sql = "SELECT confirmation_no, email
FROM reg
WHERE email='{$r['email']}'
	AND is_presenter='Yes'";
// print __FILE__ . ':' . __LINE__ .": SQL command is $sql....<br />";
$result = mysqli_query($GLOBALS['dbConnect'], $sql);

if ($r = mysqli_fetch_assoc($result)) {	//	Did we find one?
	print "<span style=\"color: green\">Found matching presenter {$r['email']} ({$r['confirmation_no']})</span><br />";
	$mydata['confirmation_no'] = $r['confirmation_no'];
} else {
	print "<span style=\"color: red\">NO MATCHING PRESENTER found. Cannot clone presentation. Please create or clone PRESENTER first, then retry this.</span>";
	$mydata['confirmation_no'] = null;
}

// print __FILE__ . ':' . __LINE__ . 'Copy to Current: got data.<br />';
// print_r($mydata);

//	Delete imported timestamp and update dates as they're not appropriate to new record.
unset($mydata['timestamp']);	//	MySQL inserts this automatically
unset($mydata['updated']);		//	MySQL inserts this automatically

if ($mydata['confirmation_no'] == null) {	//	Can't clone.
	exit;
}
// insert the new record and get the new auto_increment id

$sql = "INSERT INTO regpresenterall (`{$primarykeyfieldname}`) VALUES (NULL)";
$result = mysqli_query($GLOBALS['dbConnect'], $sql) or SM_Die('Database error on insert while copying presentation to current year: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql, 'Unable to insert new record while copying presentation to current year - sorry!');
$newid = mysqli_insert_id($GLOBALS['dbConnect']);

/*	This is SO ugly. we must skip the email data item as it's not a field in
	the table we're updating. There should be a better way but for the moment
	this will have to do.
*/

// generate the query to update the new record with the previous values

$sql = "UPDATE regpresenterall SET ";
foreach ($mydata as $key => $value) {
	if ($key != $primarykeyfieldname) {
		if (isset($fields[$key]['copyValue'])) {
			$sql .= '`'.$key.'` = "'.str_replace('"','\"',$fields[$key]['copyValue']).'", ';
		} else {
			$sql .= '`'.$key.'` = "'.str_replace('"','\"',$value).'", ';
		}
	}
} 

$sql = substr($sql, 0, strlen($sql)-2); // lop off extra trailing comma
$sql .= " WHERE {$primarykeyfieldname}={$newid}";
$result = mysqli_query($GLOBALS['dbConnect'], $sql) or SM_Die('Database error on update while copying presentation to current year: ' . mysqli_error($GLOBALS['dbConnect']) . ". Query=$sql", 'Unable to update information while copying presentation to current year - sorry!');
$sql_escaped = mysqli_real_escape_string($GLOBALS['dbConnect'], $sql);
Make_Log_Entry($GLOBALS['dbConnect'], "NEW PRESENTATION CLONED: $sql_escaped");

$e = new Smarty_Esprit;
$e->addPluginsDir("{$_SERVER['DOCUMENT_ROOT']}/plugins/");
$e->registerPlugin("modifier","ss", "stripslashes");
$e->assign('mydata',$mydata);
// print_r($tpl);
$e->addTemplateDir("{$_SERVER['DOCUMENT_ROOT']}/templates/");
$e->addTemplateDir("{$_SERVER['DOCUMENT_ROOT']}/$dirname/templates/");
$e->display('presenter_detail.tpl');


function getSameDayNextYear($date = false, $ydiff = 1, $wdiff = 0) {

	/*	Move ahead $ydiff years (defaults to one year) but keep same weekday.
		Also move ahead wdiff weeks (defaults to 0) in case the actual week of
		Esprit shifts, as it does every few years.
	 */

    if(!$date){ $date = new DateTime(); }
//     print $date->format('Y-m-d H:i').' -> ';
    $istring = "{$ydiff} year" . ($wdiff != 0 ? " {$wdiff} week" : '');	//	P1Y0W, P2Y1W etc.
//     print "\$istring = $istring; ";
    $oneYear = DateInterval::createFromDateString($istring);
    $dayOfWeek = $date->format('w');
    $nextDate = clone $date;
//     print $nextDate->format('Y-m-d H:i').' -> ';
    $nextDate->add($oneYear);
//     print $nextDate->format('Y-m-d H:i').' -> ';
    $nextYearDayOfWeek = $nextDate->format('w');
    $diff = $dayOfWeek-$nextYearDayOfWeek;
    // if $diff is more than 3, it's faster to go the other way
    if(abs($diff) > 3){
        if($diff > 0){
            $diff = $diff-7;
        }else{
            $diff = 7+$diff;
        }
    }

    if($diff != 0){
        if($diff < 0){
            $nextDate->sub(new DateInterval('P'.abs($diff).'D'));
        }else{
            $nextDate->add(new DateInterval('P'.$diff.'D'));
        }
    }
//     print $nextDate->format('Y-m-d H:i') . '<br />';

    return $nextDate;
}

?>
