<?php
/*
	Esprit Chart System, by Stephanie Mitchell
	19 August, 2019
	
	This file creates the Registrations Thermometer for the current year
	overview.
*/
require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";
require_once 'mysql_utilities.php';
require_once ".config.php";
if (!isset($_REQUEST['data'])) {

	/*	This section sets up and actually outputs the chart into a div. It is only used if this file is called without the "data=true" parameter. */
	
	define('QUADODO_IN_SYSTEM', true);
	$chart_year = $_REQUEST['chart_year'];
	print <<< STUFF
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="X-UA-Compatible" content="IE=edge" />
<title>Esprit $chart_year Online Registration Charts $test_msg</title>
<link href="../../lib/css/styles.css" rel="stylesheet" type="text/css" />
<script type="text/javascript" src="/lib/js/jquery.js"></script>
<script type="text/javascript" src="/lib/js/jquery-ui.js"></script>
<script type="text/javascript" src="/lib/js/jquerymobile.js"></script>
<script language="javascript" src="/lib/js/fusioncharts.js"></script>
<script language="javascript" src="/lib/js/fusioncharts.maps.js"></script>
<script language="javascript" src="/lib/js/fusioncharts-jquery-plugin.js"></script>
<script type="text/javascript" src="/lib/js/themes/fusioncharts.theme.esprit.js"></script>


<script type="text/javascript">
jQuery(document).ready(function(){
    $("#chart").insertFusionCharts({
		type: "thermometer",
		theme: "esprit",
		width: "400",
		height: "450",
		dataFormat: "XMLURL",
		dataSource: "regs_by_thermometer.php?data=true&chart_year=$chart_year"
    });
});
</script>

</head>
<body>
<div style="width:1800px" id="chart"></div>
STUFF;
print '
	<form id="form1" name="form1" method="post" action="#" class="noprint">
		Select a year:
		<select name="chart_year" id="chart_year" onchange="this.form.submit();">';

mysql_login('Read-only');

	$sql = "SELECT DISTINCT esprit_year
		FROM regall
		ORDER BY esprit_year DESC;";

	$result = mysqli_query($GLOBALS['dbConnect'], $sql) or die(__FILE__.'/'.__LINE__.': Database error on main query: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql);
while ($row = mysqli_fetch_array($result)) {	// collect years for dropdown
	print "<option";
	if ($chart_year == $row['esprit_year']) {
		print ' selected="selected"';
	}
	print ">".$row['esprit_year']."</option>\n";
}
mysql_logout();	//	Disconnect from database

print '		</select>
	</form>

</body>
</html>';
} else {

	/* This section compiles, formats and outputs the data required for the chart that's called above.*/
	
	define('QUADODO_IN_SYSTEM', true);
	$chart_year = $_REQUEST['chart_year'];
	mysql_login('Read-only');

//	Need to include reg_status != "DELETED" as regall includes deleted records

$sql = 'select count(*) as c
	FROM regall
	WHERE reg_status NOT LIKE "% Cancelled"
		AND reg_status != "DELETED"
		AND form_type NOT IN ("Internal", "Ticket", "Resource_Vendor", "Resource_Presenter", "Assistant")
		AND esprit_year=' .$chart_year;

	$result = mysqli_query($GLOBALS['dbConnect'], $sql) or die(__FILE__.'/'.__LINE__.': Database error on main query: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql);

/*	Get the data field (should be only a single number, the count of
	registrations) */
$row = mysqli_fetch_array($result);
mysql_logout();	//	Disconnect from database

$c = $row['c'];
$cap = $GLOBALS['esprit_cap'];
$lowcolour = '#8800FF';
$okcolour = '#00FF00';
$toohighcolour = '#FF0000';
$gaugeEndX = 0;
$gaugeEndY = 0;

switch (true) {	//	Select fill colour for attendance levels
case $c <=70:
	$fill = $lowcolour;
	break;
case $c <=140:
	$fill = $okcolour;
	break;
case $c > 140:
	$fill = $toohighcolour;
}

	$chart = "<chart
		caption=\"Esprit $chart_year Registrations to Date\"
		subcaption=\"(Excluding Vendors and Presenters)\"
		lowerlimit=\"0\"
		upperlimit=\"$cap\"
		decimals=\"1\"
		showhovereffect=\"1\"
		thmfillcolor=\"#008ee4\"
		thmBulbRadius=\"30\"
		adjustTM=\"1\"
		tickvalueStep=\"3\"
		majorTMNumber=\"15\"
		minorTMNumber=\"4\"
		showgaugeborder=\"1\"
		gaugebordercolor=\"#008ee4\"
		gaugefillcolor=\"$fill\"
		gaugeborderthickness=\"2\"
		gaugeborderalpha=\"30\"
		thmoriginx=\"150\"
		chartbottommargin=\"20\"
		valuefontcolor=\"#000000\"
		theme=\"esprit\"
		exportenabled=\"1\"
		exportformats=\"PNG=Export as PNG Image|PDF=Export as Printable|JPG=Export as JPEG|XLS=Export Chart Data\"
		exporttargetwindow=\"_self\"
		exportfilename=\"Regs Thermometer $chart_year\">
    <value>$c</value>
    <annotations showbelow=\"0\">
        <annotationgroup id=\"indicator\">
            <annotation id=\"background\" type=\"rectangle\" alpha=\"50\" fillcolor=\"#AABBCC\" x=\"$gaugeEndX-40\" tox=\"$gaugeEndX\" y=\"$gaugeEndY+54\" toy=\"$gaugeEndY+72\" />
        </annotationgroup>
    </annotations>
</chart>";

	print $chart;
}
?>
