<?php
/*
	Esprit Online Registration System
	Stephanie Mitchell, 23 November, 2017
	
	This  file contains the fieldlist details for SM_SQLEdit.
	It lists all the fields in the relevant database along with parameters
	that control their display and other characteristics.
	
	Parameters are described in detail in /help/fieldlistdoc.php.
	
*/
/*	Protect from non-logged in users */
defined('QUADODO_IN_SYSTEM') or header('HTTP/1.1 403 Forbidden')&die('Restricted access');

/* MySQL table names */

$db['tb'] = 'regreports r';
$db['tbnoalias'] = 'regreports';
global $opts;
$opts['join_clause'] = '';

/* Field definitions start here */

$fields['report_id'] = [
		'heading' => "Report ID",
		'table' => 'r',
		'display' => false,
		'fieldgroup' => '*',
		'primarykey' => true,
		'filter' => ""];
$fields['report_created'] = [
		'heading' => "Created",
		'table' => 'r',
		'display' => true,
		'search_more' => true,
		'fieldgroup' =>  '*, Master',	//	No copy to new
		'filter' => ""];
$fields['report_updated'] = [
		'heading' => "Updated",
		'table' => 'r',
		'display' => true,
		'search_more' => true,
		'fieldgroup' =>  '*, Master',	//	No copy to new
		'filter' => ""];
$fields['report_system'] = [
		'heading' => "Subsystem",
		'table' => 'r',
		'display' => true,
		'width' => '10%',
		'arrayedit' => true,
		'fieldgroup' => '*, Master',
		'filter' => ""];
$fields['report_group'] = [
		'heading' => "Group",
		'table' => 'r',
		'display' => true,
		'width' => '10%',
		'arrayedit' => true,
		'fieldgroup' => '*, Master',
		'filter' => ""];
$fields['report_esprit_online'] = [
		'heading' => "Esprit Online",
		'table' => 'r',
		'display' => true,
		'width' => '20%',
		'widget' => 'menu',
		'allowedvalues' => ["Yes", "No"],
		'allowedlabels' => ["Yes", "No"],
		'arrayedit' => true,
		'fieldgroup' => 'Master, *',
		'filter' => ""];
$fields['report_sequence'] = [
		'heading' => "Report Sequence",
		'table' => 'r',
		'display' => true,
		'width' => '10%',
		'arrayedit' => true,
		'fieldgroup' => 'Master, *',
		'filter' => ""];
$fields['report_name'] = [
		'heading' => "Report Name",
		'table' => 'r',
		'display' => true,
		'width' => '50%',
		'arrayedit' => true,
		'fieldgroup' => 'Master, *',
		'filter' => ""];
$fields['report_template'] = [
		'heading' => "External Template",
		'table' => 'r',
		'display' => true,
		'width' => '15%',
		'fieldgroup' => 'Master, *',
		'filter' => ""];
$fields['report_is_oneclick'] = [
		'heading' => "Oneclick",
		'table' => 'r',
		'display' => true,
		'width' => '5%',
		'arrayedit' => true,
		'widget' => 'menu',
		'allowedlabels' => ['', 'Yes', 'No'],
		'allowedvalues' => ['', 'Yes', 'No'],
		'fieldgroup' => 'Master, *',
		'filter' => ""];
$fields['report_query'] = [
		'heading' => "MySQL Query",
		'table' => 'r',
		'display' => true,
		'fieldgroup' => '*',
		'filter' => ""];
$fields['report_heading'] = [
		'heading' => "Report Heading",
		'table' => 'r',
		'display' => true,
		'arrayedit' => true,
		'fieldgroup' => '*',
		'filter' => ""];
$fields['report_preamble'] = [
		'heading' => "Preamble Text",
		'table' => 'r',
		'display' => true,
		'fieldgroup' => '*',
		'filter' => ""];
$fields['report_authgroup'] = [
		'heading' => "Authorised Groups",
		'table' => 'r',
		'display' => true,
		'fieldgroup' => '*',
		'filter' => ""];
$fields['report_additional'] = [
		'heading' => "Additional Items",
		'table' => 'r',
		'display' => false,
		'fieldgroup' => '*',
		'filter' => ""];
$fields['report_download'] = [
		'heading' => "Download File",
		'table' => 'r',
		'display' => true,
		'fieldgroup' => '*',
		'filter' => ""];
$fields['report_download_format'] = [
		'heading' => "Download File Format",
		'table' => 'r',
		'display' => true,
		'fieldgroup' => '*',
		'arrayedit' => true,
		'widget' => 'menu',
		'allowedvalues' => ['', 'PDF', 'Word', 'Email'],
		'allowedlabels' => ['Default', 'PDF', 'Word', 'Email'],
		'filter' => ""];
$fields['report_template_text'] = [
		'heading' => "Template Text",
		'table' => 'r',
//		'display' => true,
		'search_more' => true,
		'fieldgroup' => '*',
		'filter' => ""];

/* End of Field definitions. */

/* Field group definitions */

$tpl['fieldgroups'] = [
/*	'Blank' => ['label' => '>',
		'url' => 'blank.php'], */
	'Master' => ['label'=>'Master',
		'url' =>''],
	'Detail' => ['label' => 'Details',
		'url' => 'taburl.php?template=reports_detail.tpl',
		'authgroup' => ['Admin']],
	'Preview' => ['label' => 'Preview',
		'url' => 'taburl.php?template=reports_preview.tpl',
		'authgroup' => ['Admin']],
	'AddNew' => ['label' => 'Copy',
		'url' => 'add.php',
		'authgroup' => ['Admin'],
		'scroll' => 'No'	//	Prevent scrolling to this screen
	],
	'Logs' => ['label' => 'Log Entries',
		'url' => "../log-list.php?tbname={$db['tbnoalias']}",
		'width' => 1500,
		'height' => 800,
		'authgroup' => ['Admin']],
	'DeleteThis' => ['label' => 'Delete',
		'url' => 'delete.php',
		'authgroup' => ['Admin'],
		'scroll' => 'No'	//	Prevent scrolling to this screen
		]
];

?>