{* Smarty *}
{*	smse_accordion.tpl
	Smarty template that produces a list of records using jQuery Accordion and
	jQuery Tabs. The contents of the actual accordion lines are taken from each
	database record, showing the fields that have 'Master' in their fieldgroup
	parameter in fieldlist.php.
	
	The actual accordion contents (shown when a line is clicked) are a set of
	jQuery tabs based on $fieldgroups (found in fieldlist.php). Each tab goes to
	a corresponding <fieldgroup>url.php, the contents of which are displayed
	when the tab is clicked.
*}
<!--smse_accordion.tpl - BEGIN-->

<script>
	$(function() {
		$( ".accordion_div" ).accordion( {
			header:'.accordion',
			autoHeight: false,
			heightStyle: "content",
			active: false,
			collapsible: true } );
	});
	$(function() {
		$( ".subaccordion_div" ).accordion( {
			header:'.subaccordion',
			heightStyle: "content",
		 } );
	});
	$(function() {
		$( ".tabs" ).tabs({
			ajaxOptions: {
				cache: false,
				/* async: false, */
				error: function( xhr, status, index, anchor ) {
					$( anchor.hash ).html(
						"<span class=\"warning\">Couldn't show this tab. There may be a problem with it or it may not have been written yet.</span>" );
				}
			}
		});
	});
</script>
{$n=1}
{foreach $fields as $thisfield} {* Count master fields *}
	{if strpos(".{$thisfield.fieldgroup}", 'Master') > 0}{$n=$n+1}{/if}
{/foreach}
{$colwidth=100/$n}
<td colspan="{$n}">
{* Generate heading "row" - actually in a separate table *}
<table><tr><td width="{$colwidth}%">{$fields.$sort_field.heading}</td>
{foreach $fields as $thisfield}
	{if strpos(".{$thisfield.fieldgroup}", 'Master') > 0}
		<td width="{$colwidth}%">
		{if $thisfield@key == $sort_field}
			{if $sort_order == " DESC"}
				<button type="button" name="_sort_field_button" title="Sort ascending by {$thisfield.heading}" onClick="this.form._sort_table.value='{$thisfield.table}';this.form._sort_field.value='{$thisfield@key}';this.form._sort_order.value='';this.form._action.value='Sort';this.form.submit();"><b>{$thisfield.heading}<img src="/images/sm_desc.png"></b>
			{else}
				<button type="button" name="_sort_field_button" title="Sort descending by {$thisfield.heading}" onClick="this.form._sort_table.value='{$thisfield.table}';this.form._sort_field.value='{$thisfield@key}';this.form._sort_order.value=' DESC';this.form._action.value='Sort';this.form.submit();"><b>{$thisfield.heading}<img src="/images/sm_asc.png"></b>
			{/if}
		{else}
			{if $thisfield.callback ne ''}
				<button type="button" name="_sort_field_button" title="Can't sort by  {$thisfield.heading}" onClick="alert('Sorry - Can\'t sort by this column'); return false;"><b>{$thisfield.heading}</b>
			{else}
				<button type="button" name="_sort_field_button" title="Sort by  {$thisfield.heading}" onClick="this.form._sort_table.value='{$thisfield.table}';this.form._sort_field.value='{$thisfield@key}';this.form._sort_order.value='';this.form._action.value='Sort';this.form.submit();"><b>{$thisfield.heading}</b>
			{/if}
		{/if}
		</td>
{/if}
{/foreach}
</tr></table>
<div class="accordion_div">
{section name=sec1 loop=$data}
{$mydata=$data[sec1]}

<p class="accordion">
<table><tr><td width="{$colwidth}%">{$mydata.$sort_field}</td>
{foreach $fields as $thisfield} {* Build master field list *}
	{if strpos(".{$thisfield.fieldgroup}", 'Master') > 0}
	<td width="{$colwidth}%">{$mydata.{$thisfield@key}}</td>
	{/if}
{/foreach}
<td>&nbsp;<!--excess column width--></td></tr></table></p>
<div>
{foreach $tpl.fieldgroups as $thisgroup} {* build tabs *}
	{if $thisgroup@key ne 'Master' and ($thisgroup.authgroup eq '' or in_array($tpl.authgroup, $thisgroup.authgroup))}
		<a class="menubar" href="{$thisgroup.url}{if strpos($thisgroup.url,'?')>0}&{else}?{/if}group={$thisgroup@key}&pkfn={$primarykeyfield}&pkfv={$mydata.$primarykeyfield}&rand={rand(0,99999)}" class="highslide" onselect="return hs.htmlExpand(this, {objectType: 'ajax'})">{$thisgroup.label}</a>
		
	{/if}
{/foreach}
</div>
{/section}
</div>
</td>
<!--smse_accordion.tpl - END-->






