<?php
/*
	Esprit Online Registration System
	Stephanie Mitchell, 23 November, 2017
	
	This  file contains the fieldlist details for SM_SQLEdit.
	It lists all the fields in the relevant database along with parameters
	that control their display and other characteristics.
	
	Parameters are described in detail in /manager/help/fieldlistdoc.php.
	
*/
/*	Protect from non-logged in users */
defined('QUADODO_IN_SYSTEM') or header('HTTP/1.1 403 Forbidden')&die('Restricted access');
global $opts, $all_years;

/* MySQL table names */

$db['tb'] = 'regpayment t';
$db['tbnoalias'] = 'regpayment';
$opts['join_clause'] = '';

/* Field definitions start here */

$fields['id'] = [
		'heading' => "Key",
		'table' => 't',
		'display' => false,
		'primarykey' => true,
		'fieldgroup' => '*',
		'filter' => ""];
$fields['timestamp'] = [
		'heading' => "Time Stamp",
		'table' => 't',
		'helpfile' => 'help/timestamphelp.php',
		'display' => true,
		'css' => 'font-size:80%',
		'date_format' => '%d%b%Y %T',
		'fieldgroup' => '*, Master',
		'filter' => ""];
$fields['username'] = [
		'heading' => "Username",
		'table' => 't',
		'display' => true,
		'arrayedit'=> true,
		'fieldgroup' => '*, Master',
		'filter' => ""];
$fields['authgroup'] = [
		'heading' => "Usergroup",
		'table' => 't',
		'display' => true,
		'arrayedit'=> true,
		'fieldgroup' => '*, Master',
		'filter' => ""];
$fields['confirmation'] = [
		'heading' => "Confirmation No.",
		'table' => 't',
		'display' => true,
		'arrayedit'=> true,
		'fieldgroup' => '*, Master',
		'filter' => ""];
$fields['transtype'] = [
		'heading' => "Transaction Type",
		'table' => 't',
		'display' => true,
		'allowedvalues' => ['Registration+', 'Payment-Cash-', 'Payment-Check-',
			'Scholarship Award-', 'Onsite Purchase+', 'Discount-', 'Merchandise+',
			'Meals+', 'Excursions+','Online Payment-', 'Online Fee+',
			'Donation-Scholarship-', 'Donation-Operating-', 'Refund-', 'Yearbook Item+',
			'Adjustment Debit+', 'Adjustment Credit-',
			'Budget Transfer+', 'Test+', 'Test-'],
		'arrayedit' => true,
		'widget' => 'menu',
		'fieldgroup' => '*, Master',
		'filter' => ""];
$fields['reference'] = [
		'heading' => "Reference",
		'table' => 't',
		'display' => true,
		'arrayedit'=> true,
		'fieldgroup' => '*, Master',
		'filter' => ""];
$fields['quantity'] = [
		'heading' => "Quantity",
		'table' => 't',
		'display' => true,
		'arrayedit'=> true,
		'fieldgroup' => '*, Master',
		'filter' => ""];
$fields['source'] = [
		'heading' => "Source",
		'table' => 't',
		'display' => true,
		'arrayedit'=> true,
		'fieldgroup' => '*, Master',
		'filter' => ""];
$fields['pnotes'] = [
		'heading' => "Notes",
		'table' => 't',
		'display' => true,
		'arrayedit'=> true,
		'fieldgroup' => '*, Master',
		'filter' => ""];
$fields['addon_key'] = [
		'heading' => "Addon Key",
		'table' => 't',
		'display' => true,
		'arrayedit'=> true,
		'fieldgroup' => '*, Master',
		'filter' => ""];
$fields['addon_pointer'] = [
		'heading' => "Addon Pointer",
		'table' => 't',
		'display' => true,
		'arrayedit'=> true,
		'fieldgroup' => '*, Master',
		'filter' => ""];
$fields['amount'] = [
		'heading' => "Amount",
		'table' => 't',
		'display' => true,
		'arrayedit'=> true,
		'fieldgroup' => '*, Master',
		'filter' => ""];
$fields['tax'] = [
		'heading' => "Tax",
		'table' => 't',
		'display' => true,
		'arrayedit'=> true,
		'fieldgroup' => '*, Master',
		'filter' => ""];
$fields['receipt_no'] = [
		'heading' => "Receipt No.",
		'table' => 't',
		'display' => true,
		'arrayedit'=> true,
		'fieldgroup' => '*, Master',
		'filter' => ""];

/* End of Field definitions. */

/* Field group definitions */

$tpl['fieldgroups'] = [
	'Master' => ['label'=>'Master',
		'url' =>''],
	'Detail' => ['label' => 'Details',
		'url' => 'taburl.php?template=trans_detail.tpl',
		'authgroup' => ['Admin', 'Registrar']],
	'All' => ['label' => 'All Fields',
		'url' => '../allfieldsurl.php?dirname=trans',
		'authgroup' => ['Admin']]
];

?>