<?php
// Database variables
define('QUADODO_IN_SYSTEM', true);
require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";
require_once ".config.php";
require_once "mysql_utilities.php";
require_once "form_functions.php";
require_once "process_functions.php";
require_once 'process_emails.php';
require_once "functions.php";

// PayPal settings
global $paypal_account;	//	Set to sandbox or production in .config.php.
$return_url = 'https://reg.espritgala.org/paypalcode/payment-successful.php';
$cancel_url = 'https://reg.espritgala.org/paypalcode/payment-cancelled.php';
$notify_url = 'https://reg.espritgala.org/paypalcode/payments.php';

// Include PayPal Functions

/*
	Check if paypal request or response
*/

//	It's a request (no txn stuff from PayPal in the call)

if (!isset($_POST["txn_id"]) && !isset($_POST["txn_type"])){
	$querystring = '';
	// Firstly Append paypal account to querystring
	$querystring .= "?business=".urlencode($paypal_account)."&";
		
	//loop for posted values and append to querystring
	foreach($_POST as $key => $value){
		$value = urlencode(stripslashes($value));
		$querystring .= "$key=$value&";
	}
	
	// Append paypal return addresses
	$querystring .= "return=".urlencode(stripslashes($return_url));
	$querystring .= "&cancel_return=".urlencode(stripslashes($cancel_url));
	$querystring .= "&notify_url=".urlencode($notify_url);
	$querystring .= "&rm=2";	//	Force use of POST on return
	
	// Append querystring with custom field
// 	$querystring .= "&custom=".$confirmation_no;
	
	// Redirect to paypal IPN
// 	die(__FILE__ . '/' . __LINE__ . ': About to submit PayPal request<br />'.$querystring);
	header("location:https://{$GLOBALS['paypal_site']}/cgi-bin/webscr$querystring");

//	It's a response from PayPal (got txn_id and txn_type in the call)

} else {
	//Database Connection
// 	mysql_login('Normal');
	
	// Response from Paypal
	
	/*	Sample response:
	mc_gross=440.00&protection_eligibility=Eligible&address_status=confirmed&payer_id=AU2XNLU4XKV5A&address_street=11817+236B+Street&payment_date=17:13:43+Jan+19,+2018+PST&payment_status=Completed&charset=windows-1252&address_zip=V4R+2C9&first_name=Stephanie&mc_fee=13.06&address_country_code=CA&address_name=Stephanie+Mitchell&notify_version=3.8&custom=17018245&payer_status=unverified&business=registrar@espritgala.org&address_country=United+States&address_city=Redmond&quantity=1&verify_sign=AtzgbXK1X.9xdTmY4kIxKn.3Mc4LAUbAr9nvIRec8hMoei-bguytoZzu&payer_email=stephanie@cornbury.org&txn_id=1WE49455MT075591D&payment_type=instant&last_name=Mitchell&address_state=BC&receiver_email=registrar@espritgala.org&payment_fee=13.06&receiver_id=WYTPAXKQDRX5C&txn_type=web_accept&item_name=Esprit+2017+Registration+ID+17018245+per+CNE+TransVentions&mc_currency=CAN&item_number=&residence_country=CA&transaction_subject=&payment_gross=440.00&ipn_track_id=39fd31341d8d8

	*/

	// read the post from PayPal system and add 'cmd'
	$req = 'cmd=_notify-validate';
	foreach ($_POST as $key => $value) {
		$value = urlencode(stripslashes($value));
		$value = preg_replace('/(.*[^%^0^D])(%0A)(.*)/i','${1}%0D%0A${3}',$value);// IPN fix
		$req .= "&$key=$value";
	}
	
	// assign posted variables to local variables
	$data['item_name']			= $_POST['item_name'];
	$data['item_number'] 		= $_POST['item_number'];
	$data['payment_status'] 	= $_POST['payment_status'];
	$data['payment_amount'] 	= $_POST['mc_gross'];
	$data['payment_fee']		= $_POST['mc_fee'];
	$data['payment_currency']	= $_POST['mc_currency'];
	$data['txn_id']				= $_POST['txn_id'];
	$data['receiver_email'] 	= $_POST['receiver_email'];
	$data['payer_email'] 		= $_POST['payer_email'];
	$data['custom'] 			= $_POST['custom'];
		
	// post back to PayPal system to validate
	$header = "POST /cgi-bin/webscr HTTP/1.0\r\n";
	$header .= "Content-Type: application/x-www-form-urlencoded\r\n";
	$header .= "Content-Length: " . strlen($req) . "\r\n\r\n";
	
	/*
		Changes to PayPal sandbox when TESTING is set in .config.php
	*/
	
	$fp = fsockopen ($GLOBALS['paypal_callback'], 443, $errno, $errstr, 30);
	
	if (!$fp) {
		// HTTP ERROR
		
	} else {
		fputs($fp, $header . $req);
		while (!feof($fp)) {
			$res = fgets ($fp, 1024);
			if (strcmp($res, "VERIFIED") == 0) {
				
				// Used for debugging
				// mail('stephanie@cornbury.org', 'PAYPAL POST - VERIFIED RESPONSE', print_r($post, true));
						
				// Validate payment
				$valid_txnid = check_txnid($data['txn_id']);
				// PAYMENT VALIDATED & VERIFIED!
				if ($valid_txnid) {
					
					$orderid = updatePayments($data);	//	Presently does
					//	nothing. PayPal is supposed to call
					//	payment-successful.php with all the parameters, which
					//	then does all the posting and logging.
					
					if ($orderid) {
						// Payment has been made & successfully inserted into the Database
					} else {
						// Error inserting into DB
						// E-mail admin or alert user
						// mail('user@domain.com', 'PAYPAL POST - INSERT INTO DB WENT WRONG', print_r($data, true));
					}
				} else {
					// Payment made but data has been changed
					// E-mail admin or alert user
				}
			
			} else if (strcmp ($res, "INVALID") == 0) {
			
				// PAYMENT INVALID & INVESTIGATE MANUALY!
				// E-mail admin or alert user
				
				// Used for debugging
				//@mail("user@domain.com", "PAYPAL DEBUGGING", "Invalid Response<br />data = <pre>".print_r($post, true)."</pre>");
			}
		}
	fclose ($fp);
	}
}
?>
