<?php
function process_payment($p, $f, $trans, $conf) {
	require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";
	require_once ".config.php";
	require_once "mysql_utilities.php";
	require_once "process_functions.php";
	define('QUADODO_IN_SYSTEM', true);
	$result = '';
	if ($p['scholapplication'] == 'Yes') {
		$result = "<h2>You've indicated you're applying for a scholarship.</h2>
	<p>You don't need to send any money now, but you must complete a scholarship application.
	<form method=\"post\" action=\"scholapp/index2.php\">
	<input type=\"hidden\" name=\"email\" id=\"email\" value=\"{$p['email']}\" />
	<input type=\"hidden\" name=\"confirmation_no\" id=\"confirmation_no\" value=\"{$p['confirmation_no']}\" />
		<input type=\"submit\" id=\"postbut\" name=\"Submit\" value=\"I want to apply now\" />
	</form>";
	} else {
		$email = get_conf_email($p);
//  	print __FUNCTION__ . ' result:<pre>'; print_r($p);print '</pre><br />';
//   	print __FUNCTION__ . ' trans:<pre>'; print_r($trans);print '</pre><br />';
		$result = process_payment_page($p['noupload']['source_form_type'], get_transactions($conf), $conf);
	}
	return $result;
}

function process_payment_page($form_type, $trans, $confirmation_no) {
	require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";
	require_once ".config.php";
	require_once "mysql_utilities.php";
	require_once "process_functions.php";
	global $paypal_account, $esprit_address, $esprit_treasurer_address;
//   	print __FUNCTION__ . ' $paypal_account:<pre>'; print $paypal_account;print '</pre><br />';
	$trans_total = 0;
	foreach ($trans as $this_key => $this_trans) {
		$this_amount = $this_trans['amount'] + $this_trans['tax'];
		$trans_total += $this_amount;
	}
	switch (true) {
	
	case ($confirmation_no == ''):
		$result = DeAliasString("<h2>Oops...</h2>
		<p>There seems to be a problem; no confirmation number was found in our payment processing page. Please email us at registrar@espritgala.org with the details and we'll look into it.</p>");
		break;
		
	case ($trans_total <= 0):
		$result = DeAliasString("<h2>Good news!</h2><p>According to our records, you don't owe anything.!</p>
		<p>However, if you believe this is wrong, please email us at registrar@espritgala.org with the details and we'll look into it.</p>");
		break;
		
	default:
	
		if (!$GLOBALS['paypal_accepted']) {	//	PayPal suspended?
			$result = "<h2>Now - two ways to pay!</h2>
			<p>You can pay <span class=\"bold\">by mail</span> or <span class=\"bold\">in person.</span></p><p class=\"bold\">We regret that PayPal is not currently available.</p>";
		} else {
			$result = "<h2>Now - three ways to pay!</h2>
			<p>You can pay <span class=\"bold\">with PayPal</span>, <span class=\"bold\">by mail</span> or <span class=\"bold\">in person.</span></p>";
			$result .= "<ol>
			<li><span class=\"bold\">To pay with PayPal,</span> click ";
			$result .= generate_paypal_link($paypal_account, $confirmation_no, $trans_total);
			if (TESTING) {
					$result .= "<p class=\"errorsummary\">BE CAREFUL. Even though the system is in TEST mode, this button is LIVE. You can click it to test, but if you continue to PayPal and click the Pay Now button, YOU WILL PAY REAL MONEY. It will be only $1.00 while we're testing, but the refund process is a nuisance.</p>";
			$result .= "</li>";
			}
		}
		if ($form_type == 'Donor') {
			$result .= "<li><span class=\"bold\">To pay by check or money order, </span>print out two copies of your donation Thank You email. Sign one copy and mail it with your payment to<br />
			<span class=\"bold\">$esprit_address<br />
			<br />
			</span>Make checks payable to <span class=\"i\">Esprit</span>.<br />
			<br />
			</li>
			</ol>";

		} else {
			$result .= "<li><span class=\"bold\">To pay by check or money order, </span>print out two copies of your Registration Letter. Review the sections on code of conduct and refund policies, then sign one copy and mail it with your payment to<br />
			<span class=\"bold\">$esprit_address<br />
			<br />
			</span>Make checks payable to <span class=\"i\">Esprit</span>.<br />
			<br />
			</li>
			<li><span class=\"bold\">To pay in person upon arrival, </span>bring cash or a check or money order for the full amount owing. the prompt payment discount doesn't apply at the door.<br /></li>
			<li><span class=\"bold\">If you're applying for a scholarship, </span>you don't need to send payment. Simply note that on your letter.</li>
			</ol>";
		}
	}
	return $result;
}
?>
